import { world } from "@minecraft/server";
import { FatItem } from "./item/Fat";
import { chrysalis_grow, chrysalis_update } from "./block/Chrysalis";
export class Register {
  constructor() {
    Register.#registerBlockEvents();
    Register.#registerItemEvents();
  }
  static #registerBlockEvents() {
    e.blockComponentRegistry.registerCustomComponent('sf_nba:chrysalis_grow', { onRandomTick: chrysalis_grow });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:chrysalis_update', { onTick: chrysalis_update });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:three_stage_egg', { onRandomTick: three_stage_egg_step });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:one_stage_egg', { onRandomTick: one_stage_egg_step });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:delicate_egg', { onStepOn: damage_egg, onEntityFallOn: damage_egg });
  }
  static #registerItemEvents() {
    world.beforeEvents.worldInitialize.subscribe((e) => {
      e.itemComponentRegistry.registerCustomComponent('sf_nba:fat', new FatItem());
    });
  }
}
new Register();